/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts;

import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import com.github.glodblock.extendedae.common.me.taglist.TagExpParser;
import com.github.glodblock.extendedae.common.me.taglist.TagPriorityList;
import com.github.glodblock.extendedae.common.parts.base.PartSpecialStorageBus;
import com.github.glodblock.extendedae.container.ContainerTagStorageBus;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class PartTagStorageBus
extends PartSpecialStorageBus {
    public static final class_2960 MODEL_BASE = new class_2960("extendedae", "part/tag_storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new class_2960[]{MODEL_BASE, new class_2960("ae2", "part/storage_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new class_2960[]{MODEL_BASE, new class_2960("ae2", "part/storage_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new class_2960[]{MODEL_BASE, new class_2960("ae2", "part/storage_bus_has_channel")});
    private String oreExpWhite = "";
    private String oreExpBlack = "";

    public PartTagStorageBus(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.oreExpWhite = data.method_10558("oreExp");
        this.oreExpBlack = data.method_10558("oreExp2");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10582("oreExp", this.oreExpWhite);
        data.method_10582("oreExp2", this.oreExpBlack);
    }

    @Override
    public class_3917<?> getMenuType() {
        return ContainerTagStorageBus.TYPE;
    }

    protected final int getUpgradeSlots() {
        return 2;
    }

    public void setTagFilter(String exp, boolean isWhite) {
        if (isWhite) {
            if (!exp.equals(this.oreExpWhite)) {
                this.oreExpWhite = exp;
                this.filter = null;
                this.forceUpdate();
            }
        } else if (!exp.equals(this.oreExpBlack)) {
            this.oreExpBlack = exp;
            this.filter = null;
            this.forceUpdate();
        }
    }

    public String getTagFilter(boolean isWhite) {
        return isWhite ? this.oreExpWhite : this.oreExpBlack;
    }

    @Override
    protected IPartitionList createFilter() {
        if (this.filter == null) {
            this.filter = new TagPriorityList(TagExpParser.getMatchingOre(this.oreExpWhite), TagExpParser.getMatchingOre(this.oreExpBlack), this.oreExpWhite + this.oreExpBlack);
        }
        return this.filter;
    }

    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        this.oreExpWhite = input.method_10545("ore_dict_exp") ? input.method_10558("ore_dict_exp") : "";
        this.oreExpBlack = input.method_10545("ore_dict_exp_2") ? input.method_10558("ore_dict_exp_2") : "";
    }

    public void exportSettings(SettingsFrom mode, class_2487 output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.method_10582("ore_dict_exp", this.oreExpWhite);
            output.method_10582("ore_dict_exp_2", this.oreExpBlack);
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

